<?php
session_start();
include 'includes/db.php';

// Mark Expired
mysqli_query($conn, "UPDATE members SET payment_status = 'Expired' WHERE expiry_date < CURDATE()");

// Mark Due (within next 7 days)
mysqli_query($conn, "
    UPDATE members 
    SET payment_status = 'Due' 
    WHERE expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY)
");

// Mark OK
mysqli_query($conn, "
    UPDATE members 
    SET payment_status = 'OK' 
    WHERE expiry_date > DATE_ADD(CURDATE(), INTERVAL 7 DAY)
");

$_SESSION['message'] = "Member statuses updated!";
header("Location: dashboard.php");
exit;
